/** An array that changes to fit the required size */
public class DynamicArray{
   private int[] b;// b[0..n-1] are the array elements. If n!=0,
   private int n;  // b[n-1] is the array element with highest index
                   // into which a value was stored.
   
   /** Constructor: an array with 10 elements allocated */
   public DynamicArray() {
      b= new int[10];
      n= 0;
   }
      
   /** Constructor: an array with e (>0) elements allocated */
   public DynamicArray (int e) {
      b= new int[e];
      n= 0;
   } 

   /** = the number of elements in array that are currently
         in use: 1+(maximum index into which a value was stored) */
   public int length() {
      return n;
   }
   
   /** = the length of the allocated array */
   public int allocatedLength() {
      return b.length;
   }
   
   /** = the element at index i (given 0 <= i < length()) */
   public int get(int i) {
      return b[i];
   }
   
   /** set the element at position i to v (0 <= i) */
   public void set(int i, int v) {
      if (i >= b.length) {
         // Create in newb a new array that has at least i+1
         // elements. For efficiency purposes, it is best to
         // at least double the array size
            int[] newb= new int[Math.max(i+1, 2*b.length)];
         
         // Copy b[0..length()] into array newb
            // inv: 0 <= j <= length() and 
            // b[0..j-1] has been copied to newb[0..j-1]
            for (int j= 0; j != length(); j++)
               {newb[j]= b[j];}
            
         b= newb;
      }   
         
      // {i < b.length, so v can be stored in b[i]}
      
      b[i]= v; n= Math.max(n, i+1);
   } 

}
